<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN907030NL - Get Interaction Version Query</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <!--pattern is-a="attentionLine" id="PRPM_IN907030NL-attentionLine">
        <param name="messagePatientId"
            value="hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId/hl7:value"/>
        <param name="attentionLineOptional" value="'true'"/>
    </pattern-->
    
    <pattern is-a="transmission-wrapper" id="PRPM_IN907030NL-wrapper">
        <param name="element" value="hl7:PRPM_IN907030NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN907030NL-controlAct">
        <param name="element" value="hl7:PRPM_IN907030NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN907030NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN907030NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN907030NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- sender -->
        <rule context="hl7:PRPM_IN907030NL/hl7:sender/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De zender van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
        <!-- receiver -->
        <rule context="hl7:PRPM_IN907030NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn</assert>
        </rule>
    </pattern>

    <pattern>
        <title>QueryByParameter</title>
        <rule context="hl7:queryByParameter">
            <assert role="error" test="not(hl7:applicationId and hl7:patientId)"
                >De elementen applicationId en patientId mogen niet beide voorkomen.</assert>
            <assert role="error" test="not(hl7:effectiveTime) or hl7:patientId"
                >effectiveTime mag alleen voorkomen in combinatie met patientId.</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:responseModalityCode">
            <extends rule="CS"/>
            <assert test="@code='R'">responseModalityCode moet vaste waarde 'R' hebben.</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:applicationId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >Het attribuut applicationId/value/@root moet de waarde “2.16.840.1.113883.2.4.6.6” bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:effectiveTime/hl7:value/*">
            <extends rule="IVL_TS"/>
            <assert role="error" test="local-name(.)='low' or local-name(.)='high'"
                >Alleen periodes op basis van effectiveTime/value/low (actualiteit ondergrens) en/of effectiveTime/value/high/ (actualiteit bovengrens) zijn toegestaan</assert>
            <assert role="error" test="./@value"
                >Alleen periodes op basis van effectiveTime/value/low/@value (actualiteit ondergrens) en/of effectiveTime/value/high/@value (actualiteit bovengrens) zijn toegestaan</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:interactionId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.1.6'"
                >Het attribuut interactionId/value/@root moet de waarde “2.16.840.1.113883.1.6” bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:patientId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
                >Het attribuut patientId/value/@root moet de waarde “2.16.840.1.113883.2.4.6.3” bevatten</assert>
        </rule>
    </pattern>
</schema>
